<%@page contentType="text/html;charset=utf-8"%>
<!DOCTYPE html >
<head>
<meta charset="utf-8"/>
<title>IBSheet7-Product</title>
	<script type="text/javascript" src="../Chart/jquery-1.7.2.min.js"></script>
	<script type="text/javascript" src="../js/common.js"></script>
    <script type="text/javascript" src="../Chart/highcharts/highcharts.js"></script>
	<script type="text/javascript" src="../Chart/ibchart.js"></script>
	<script type="text/javascript" src="../Chart/ibchartinfo.js"></script>

	<script type="text/javascript">
		function init_chart(){
			createIBChart("myChart", "myChart", {
				width: "100%",
				height: "275px"
			});
			myChart.draw();
		}
		function doAction(str){
			switch(str){
				case 'search':
					switch(document.getElementById("sel_TP").value){
						case "01":
							a = "left";
							va = "top";
						break;
						case "02":
							a = "center";
							va = "top";
						break;
						case "03":
							a = "right";
							va = "top";
						break;
						case "04":
							a = "left";
							va = "middle";
						break;
						case "05":
							a = "center";
							va = "middle";
						break;
						case "06":
							a = "right";
							va = "middle";
						break;
						case "07":
							a = "left";
							va = "bottom";
						break;
						case "08":
							a = "center";
							va = "bottom";
						break;
						case "09":
							a = "right";
							va = "bottom";
						break;
					}
					l = document.getElementById("sel_LayOut").value=="가로"?"horizontal":"vertical";
					f = document.getElementById("chk_Float").checked;
					myChart.setOptions({
						legend:{
							enabled:true,
							layout:l,
							align:a,
							verticalAlign:va,
							margin:10,
							x:0,
							y:0,
							floation:f
						}
					},{
						append: true
					});
					var opt  = {
						append: true,
						param:{
							SERIES_CNT:4,
							LEGEND_T:document.getElementById("txt_Desc").value
						}
					};

					DoSearch(myChart, "practice4_data.jsp", opt);
					break;
				case 'load':
					switch(document.getElementById("sel_TP").value){
							case "01":
								a = "left";
								va = "top";
							break;
							case "02":
								a = "center";
								va = "top";
							break;
							case "03":
								a = "right";
								va = "top";
							break;
							case "04":
								a = "left";
								va = "middle";
							break;
							case "05":
								a = "center";
								va = "middle";
							break;
							case "06":
								a = "right";
								va = "middle";
							break;
							case "07":
								a = "left";
								va = "bottom";
							break;
							case "08":
								a = "center";
								va = "bottom";
							break;
							case "09":
								a = "right";
								va = "bottom";
							break;
						}
						l = document.getElementById("sel_LayOut").value=="가로"?"horizontal":"vertical";
						f = document.getElementById("chk_Float").checked;
						myChart.setOptions({
							legend:{
								enabled:true,
								layout:l,
								align:a,
								verticalAlign:va,
								margin:10,
								x:0,
								y:0,
								floating:f
							}
						},{
							append: true
						});
					// var scnt = document.getElementById("series_cnt").value;
					// myChart.loadSearchData(xmlstr, {
					// 	append: true
					// });
					DoSearch(myChart,"practice3_data.xml", {
						append : true,
						sync: true
					});
				break;
			}
		}

		function DoSearch(chart,url,subparam){
			$.ajax({
				type: 'post'
				, async: subparam.sync
				, dataType:"text"
				, url: url
				, data: subparam.param
				, beforeSend: function() {

				}
				, success: function(xml) {
					chart.loadSearchData(xml,subparam);
				}
				, error: function(data, status, err) {
					alert('서버와의 통신이 실패했습니다.');
				}
				,complete:function(jqXHR,textStatus){

				}
			});
		}
	</script>
</head>

<body onload="init_chart()">

	<div class="page_title">
		<span><a class="closeDepth" href="#">closeDepth</a></span>
		<span class="title color_sheet">차트개발 실습  > <b>범례</b></span>
	</div>

	<div class="main_content">
		<div class="exp_product">
			범례의 위치 및 타이틀 설정한다.
		</div>

		<p class="subtit_chart">기능 버튼</p>
		<div class="ib_function2 border_chart">
			<table class="ib_column2">
				<tr>
					<th class="tit">범례 위치</th>
					<td class="r20">
						<select class="input_all" name="sel_TP" id="sel_TP" title="범례 위치 설정">
							<option value="01" >좌상</option>
							<option value="02" >중상</option>
							<option value="03" >우상</option>

							<option value="04" >좌중</option>
							<option value="05" >중중</option>
							<option value="06" >우중</option>

							<option value="07" >좌하</option>
							<option selected value="08" >중하</option>
							<option value="09" >우하</option>
						</select>
					</td>
					<th class="tit">범례 정렬</th>
					<td class="r20">
						<select class="input_all" name="sel_LayOut" id="sel_LayOut" title="LayOut 설정">
							<option value="가로" >가로</option>
							<option value="세로" >세로</option>
						</select>
					</td>
				</tr>
				<tr>
					<th class="tit">플로팅여부</th>
					<td class="r20">
						<input type="checkbox" name="chk_Float" id="chk_Float" title="플로팅여부">
					</td>

					<th class="tit">범례내용</th>
					<td class="r20">
						<input type="text" name="txt_Desc" id="txt_Desc" class="inputbox2"  value="Legend Label">
					</td>
					<th class="tit"></th>
					<td class="r20">
						<a href="javascript:doAction('search');" class="f2_btn_white btn_chart">확인</a>
					</td>
					<!-- <th class="tit">XML String Load</th>
					<td class="r20">
						<a href="javascript:doAction('load');" class="f2_btn_white btn_chart">확인</a>
					</td> -->
				</tr>
			</table>
		</div>
		<p class="subtit_chart">IB Chart</p>
		<br/>
		<div class="ib_product">
			<div id="myChart"></div>
		</div>
	</div>
    <!--main_content-->
</body>
</html>








